"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(hub, ctx, account_details: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.  CreateMembers is always used to add accounts that are not organization members. For accounts that are managed using Organizations, CreateMembers is only used in the following cases:   Security Hub is not configured to automatically add new organization accounts.   The account was disassociated or deleted in Security Hub.   This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the EnableSecurityHub operation. For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the InviteMembers operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub. Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub, and Security Hub is automatically enabled for those accounts. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account. A permissions policy is added that permits the administrator account to view the findings generated in the member account. When Security Hub is enabled in a member account, the member account findings are also visible to the administrator account.  To remove the association between the administrator and member accounts, use the DisassociateFromMasterAccount or DisassociateMembers operation.

    Args:
        account_details(List): The list of accounts to associate with the Security Hub administrator account. For each account, the list includes the account ID and optionally the email address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.member.create_multiple(ctx, account_details=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.member.create_multiple account_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="create_members",
        op_kwargs={"AccountDetails": account_details},
    )


async def delete_multiple(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified member accounts from Security Hub. Can be used to delete member accounts that belong to an organization as well as member accounts that were invited manually.

    Args:
        account_ids(List): The list of account IDs for the member accounts to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.member.delete_multiple(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.member.delete_multiple account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="delete_members",
        op_kwargs={"AccountIds": account_ids},
    )


async def disassociate(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified member accounts from the associated administrator account. Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.

    Args:
        account_ids(List): The account IDs of the member accounts to disassociate from the administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.member.disassociate(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.member.disassociate account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="disassociate_members",
        op_kwargs={"AccountIds": account_ids},
    )


async def get_all(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details for the Security Hub member accounts for the specified account IDs. An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually. The results include both member accounts that are managed using Organizations and accounts that were invited manually.

    Args:
        account_ids(List): The list of account IDs for the Security Hub member accounts to return the details for. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.member.get_all(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.member.get_all account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="get_members",
        op_kwargs={"AccountIds": account_ids},
    )


async def invite(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from. This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations. Before you can use this action to invite a member, you must first use the CreateMembers action to create the member account in Security Hub. When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.

    Args:
        account_ids(List): The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.member.invite(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.member.invite account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="invite_members",
        op_kwargs={"AccountIds": account_ids},
    )


async def list_all(
    hub,
    ctx,
    only_associated: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists details about all member accounts for the current Security Hub administrator account. The results include both member accounts that belong to an organization and member accounts that were invited manually.

    Args:
        only_associated(bool, optional): Specifies which member accounts to include in the response based on their relationship status with the administrator account. The default value is TRUE. If OnlyAssociated is set to TRUE, the response includes member accounts whose relationship status with the administrator account is set to ENABLED. If OnlyAssociated is set to FALSE, the response includes all existing member accounts. . Defaults to None.
        max_results(int, optional): The maximum number of items to return in the response. . Defaults to None.
        next_token(str, optional): The token that is required for pagination. On your first call to the ListMembers operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.member.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.member.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="list_members",
        op_kwargs={
            "OnlyAssociated": only_associated,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
