"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, insight_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the results of the Security Hub insight specified by the insight ARN.

    Args:
        insight_arn(str): The ARN of the insight for which to return results.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.insight.result.get_all(ctx, insight_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.insight.result.get_all insight_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="get_insight_results",
        op_kwargs={"InsightArn": insight_arn},
    )
