"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, filters: Dict, group_by_attribute: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation. To group the related findings in the insight, use the GroupByAttribute.

    Args:
        name(str): The name of the custom insight to create.
        filters(Dict): One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.
        group_by_attribute(str): The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.insight.init.create(
                ctx, name=value, filters=value, group_by_attribute=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.insight.init.create name=value, filters=value, group_by_attribute=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="create_insight",
        op_kwargs={
            "Name": name,
            "Filters": filters,
            "GroupByAttribute": group_by_attribute,
        },
    )


async def delete(hub, ctx, insight_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the insight specified by the InsightArn.

    Args:
        insight_arn(str): The ARN of the insight to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.insight.init.delete(ctx, insight_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.insight.init.delete insight_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="delete_insight",
        op_kwargs={"InsightArn": insight_arn},
    )


async def get_all(
    hub, ctx, insight_arns: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists and describes insights for the specified insight ARNs.

    Args:
        insight_arns(List, optional): The ARNs of the insights to describe. If you do not provide any insight ARNs, then GetInsights returns all of your custom insights. It does not return any managed insights. Defaults to None.
        next_token(str, optional): The token that is required for pagination. On your first call to the GetInsights operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of items to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.insight.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.insight.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="get_insights",
        op_kwargs={
            "InsightArns": insight_arns,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    insight_arn: str,
    name: str = None,
    filters: Dict = None,
    group_by_attribute: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Security Hub insight identified by the specified insight ARN.

    Args:
        insight_arn(str): The ARN of the insight that you want to update.
        name(str, optional): The updated name for the insight. Defaults to None.
        filters(Dict, optional): The updated filters that define this insight. Defaults to None.
        group_by_attribute(str, optional): The updated GroupBy attribute that defines this insight. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.insight.init.update(ctx, insight_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.insight.init.update insight_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="update_insight",
        op_kwargs={
            "InsightArn": insight_arn,
            "Name": name,
            "Filters": filters,
            "GroupByAttribute": group_by_attribute,
        },
    )
