"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, product_subscription_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.

    Args:
        product_subscription_arn(str): The ARN of the integrated product to disable the integration for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.import_finding.for_product.disable(
                ctx, product_subscription_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.import_finding.for_product.disable product_subscription_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="disable_import_findings_for_product",
        op_kwargs={"ProductSubscriptionArn": product_subscription_arn},
    )


async def enable(hub, ctx, product_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub. When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.

    Args:
        product_arn(str): The ARN of the product to enable the integration for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.import_finding.for_product.enable(
                ctx, product_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.import_finding.for_product.enable product_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="enable_import_findings_for_product",
        op_kwargs={"ProductArn": product_arn},
    )
