"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, hub_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about the Hub resource in your account, including the HubArn and the time when you enabled Security Hub.

    Args:
        hub_arn(str, optional): The ARN of the Hub resource to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.hub.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.hub.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="describe_hub",
        op_kwargs={"HubArn": hub_arn},
    )
