"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the current Security Hub member account from the associated administrator account. This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.from_.administrator_account.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.from_.administrator_account.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="disassociate_from_administrator_account",
        op_kwargs={},
    )
