"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    filters: Dict = None,
    sort_criteria: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of findings that match the specified criteria.

    Args:
        filters(Dict, optional): The finding attributes used to define a condition to filter the returned findings. You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values. Note that in the available filter fields, WorkflowState is deprecated. To search for a finding based on its workflow status, use WorkflowStatus. Defaults to None.
        sort_criteria(List, optional): The finding attributes used to sort the list of returned findings. Defaults to None.
        next_token(str, optional): The token that is required for pagination. On your first call to the GetFindings operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of findings to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.finding.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.finding.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="get_findings",
        op_kwargs={
            "Filters": filters,
            "SortCriteria": sort_criteria,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update_multiple(
    hub, ctx, filters: Dict, note: Dict = None, record_state: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     UpdateFindings is deprecated. Instead of UpdateFindings, use BatchUpdateFindings. Updates the Note and RecordState of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.

    Args:
        filters(Dict): A collection of attributes that specify which findings you want to update.
        note(Dict, optional): The updated note for the finding. Defaults to None.
        record_state(str, optional): The updated record state for the finding. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.finding.update_multiple(ctx, filters=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.finding.update_multiple filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="update_findings",
        op_kwargs={"Filters": filters, "Note": note, "RecordState": record_state},
    )
