"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    standards_subscription_arns: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the standards that are currently enabled.

    Args:
        standards_subscription_arns(List, optional): The list of the standards subscription ARNs for the standards to retrieve. Defaults to None.
        next_token(str, optional): The token that is required for pagination. On your first call to the GetEnabledStandards operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.enabled.standard.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.enabled.standard.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="get_enabled_standards",
        op_kwargs={
            "StandardsSubscriptionArns": standards_subscription_arns,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
