"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, standards_subscription_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Enables the standards specified by the provided StandardsArn. To obtain the ARN for a standard, use the DescribeStandards operation. For more information, see the Security Standards section of the Security Hub User Guide.

    Args:
        standards_subscription_requests(List): The list of standards checks to enable.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.enable.standard.batch(
                ctx, standards_subscription_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.enable.standard.batch standards_subscription_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="batch_enable_standards",
        op_kwargs={"StandardsSubscriptionRequests": standards_subscription_requests},
    )
