"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, standards_subscription_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Disables the standards specified by the provided StandardsSubscriptionArns. For more information, see Security Standards section of the Security Hub User Guide.

    Args:
        standards_subscription_arns(List): The ARNs of the standards subscriptions to disable.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.disable_standard.batch(
                ctx, standards_subscription_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.disable_standard.batch standards_subscription_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="batch_disable_standards",
        op_kwargs={"StandardsSubscriptionArns": standards_subscription_arns},
    )
