"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(hub, ctx, administrator_id: str, invitation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from. This operation is only used by member accounts that are not added through Organizations. When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.

    Args:
        administrator_id(str): The account ID of the Security Hub administrator account that sent the invitation.
        invitation_id(str): The identifier of the invitation sent from the Security Hub administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.administrator.invitation.accept(
                ctx, administrator_id=value, invitation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.administrator.invitation.accept administrator_id=value, invitation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="accept_administrator_invitation",
        op_kwargs={"AdministratorId": administrator_id, "InvitationId": invitation_id},
    )
