"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Provides the details for the Security Hub administrator account for the current member account. Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.administrator.account.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.administrator.account.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="get_administrator_account",
        op_kwargs={},
    )
