"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, description: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom action target in Security Hub. You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.

    Args:
        name(str): The name of the custom action target. Can contain up to 20 characters.
        description(str): The description for the custom action target.
        id_(str): The ID for the custom action target. Can contain up to 20 alphanumeric characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.action_target.create(
                ctx, name=value, description=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.action_target.create name=value, description=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="create_action_target",
        op_kwargs={"Name": name, "Description": description, "Id": id_},
    )


async def delete(hub, ctx, action_target_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a custom action target from Security Hub. Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.

    Args:
        action_target_arn(str): The ARN of the custom action target to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.action_target.delete(ctx, action_target_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.action_target.delete action_target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="delete_action_target",
        op_kwargs={"ActionTargetArn": action_target_arn},
    )


async def describe_all(
    hub,
    ctx,
    action_target_arns: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the custom action targets in Security Hub in your account.

    Args:
        action_target_arns(List, optional): A list of custom action target ARNs for the custom action targets to retrieve. Defaults to None.
        next_token(str, optional): The token that is required for pagination. On your first call to the DescribeActionTargets operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.action_target.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.action_target.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="describe_action_targets",
        op_kwargs={
            "ActionTargetArns": action_target_arns,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, action_target_arn: str, name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the name and description of a custom action target in Security Hub.

    Args:
        action_target_arn(str): The ARN of the custom action target to update.
        name(str, optional): The updated name of the custom action target. Defaults to None.
        description(str, optional): The updated description for the custom action target. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.action_target.update(ctx, action_target_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.action_target.update action_target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="update_action_target",
        op_kwargs={
            "ActionTargetArn": action_target_arn,
            "Name": name,
            "Description": description,
        },
    )
