"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def replicate(
    hub,
    ctx,
    secret_id: str,
    add_replica_regions: List,
    force_overwrite_replica_secret: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Converts an existing secret to a multi-Region secret and begins replication the secret to a list of new regions.

    Args:
        secret_id(str): Use the Secret Id to replicate a secret to regions.
        add_replica_regions(List): Add Regions to replicate the secret.
        force_overwrite_replica_secret(bool, optional): (Optional) If set, Secrets Manager replication overwrites a secret with the same name in the destination region. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.secretsmanager.secret.to_region.replicate(
                ctx, secret_id=value, add_replica_regions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.secretsmanager.secret.to_region.replicate secret_id=value, add_replica_regions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="secretsmanager",
        operation="replicate_secret_to_regions",
        op_kwargs={
            "SecretId": secret_id,
            "AddReplicaRegions": add_replica_regions,
            "ForceOverwriteReplicaSecret": force_overwrite_replica_secret,
        },
    )
