"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def stop(hub, ctx, secret_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the secret from replication and promotes the secret to a regional secret in the replica Region.

    Args:
        secret_id(str): Response to StopReplicationToReplica of a secret, based on the SecretId.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.secretsmanager.replication_to_replica.stop(ctx, secret_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.secretsmanager.replication_to_replica.stop secret_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="secretsmanager",
        operation="stop_replication_to_replica",
        op_kwargs={"SecretId": secret_id},
    )
