"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    password_length: int = None,
    exclude_characters: str = None,
    exclude_numbers: bool = None,
    exclude_punctuation: bool = None,
    exclude_uppercase: bool = None,
    exclude_lowercase: bool = None,
    include_space: bool = None,
    require_each_included_type: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a random password of the specified complexity. This operation is intended for use in the Lambda rotation function. Per best practice, we recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.  Minimum permissions  To run this command, you must have the following permissions:   secretsmanager:GetRandomPassword

    Args:
        password_length(int, optional): The desired length of the generated password. The default value if you do not include this parameter is 32 characters. Defaults to None.
        exclude_characters(str, optional): A string that includes characters that should not be included in the generated password. The default is that all characters from the included sets can be used. Defaults to None.
        exclude_numbers(bool, optional): Specifies that the generated password should not include digits. The default if you do not include this switch parameter is that digits can be included. Defaults to None.
        exclude_punctuation(bool, optional): Specifies that the generated password should not include punctuation characters. The default if you do not include this switch parameter is that punctuation characters can be included. The following are the punctuation characters that can be included in the generated password if you don't explicitly exclude them with ExcludeCharacters or ExcludePunctuation:  ! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~ . Defaults to None.
        exclude_uppercase(bool, optional): Specifies that the generated password should not include uppercase letters. The default if you do not include this switch parameter is that uppercase letters can be included. Defaults to None.
        exclude_lowercase(bool, optional): Specifies that the generated password should not include lowercase letters. The default if you do not include this switch parameter is that lowercase letters can be included. Defaults to None.
        include_space(bool, optional): Specifies that the generated password can include the space character. The default if you do not include this switch parameter is that the space character is not included. Defaults to None.
        require_each_included_type(bool, optional): A boolean value that specifies whether the generated password must include at least one of every allowed character type. The default value is True and the operation requires at least one of every character type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.secretsmanager.random_password.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.secretsmanager.random_password.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="secretsmanager",
        operation="get_random_password",
        op_kwargs={
            "PasswordLength": password_length,
            "ExcludeCharacters": exclude_characters,
            "ExcludeNumbers": exclude_numbers,
            "ExcludePunctuation": exclude_punctuation,
            "ExcludeUppercase": exclude_uppercase,
            "ExcludeLowercase": exclude_lowercase,
            "IncludeSpace": include_space,
            "RequireEachIncludedType": require_each_included_type,
        },
    )
