"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def domain(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns information about the domain, including when the domain was created, the number of items and attributes in the domain, and the size of the attribute names and values.

    Args:
        domain_name(str): The name of the domain for which to display the metadata of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.metadata.domain(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.metadata.domain domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="domain_metadata",
        op_kwargs={"DomainName": domain_name},
    )
