"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def select(
    hub,
    ctx,
    select_expression: str,
    next_token: str = None,
    consistent_read: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     The Select operation returns a set of attributes for ItemNames that match the select expression. Select is similar to the standard SQL SELECT statement.   The total size of the response cannot exceed 1 MB in total size. Amazon SimpleDB automatically adjusts the number of items returned per page to enforce this limit. For example, if the client asks to retrieve 2500 items, but each individual item is 10 kB in size, the system returns 100 items and an appropriate NextToken so the client can access the next page of results.   For information on how to construct select expressions, see Using Select to Create Amazon SimpleDB Queries in the Developer Guide.

    Args:
        select_expression(str): The expression used to query the domain.
        next_token(str, optional): A string informing Amazon SimpleDB where to start the next list of ItemNames. Defaults to None.
        consistent_read(bool, optional): Determines whether or not strong consistency should be enforced when data is read from SimpleDB. If true, any data previously written to SimpleDB will be returned. Otherwise, results will be consistent eventually, and the client may not see data that was written immediately before your read. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.init.select(ctx, select_expression=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.init.select select_expression=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="select",
        op_kwargs={
            "SelectExpression": select_expression,
            "NextToken": next_token,
            "ConsistentRead": consistent_read,
        },
    )
