"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, domain_name: str) -> None:
    r"""
    **Autogenerated function**

     The CreateDomain operation creates a new domain. The domain name should be unique among the domains associated with the Access Key ID provided in the request. The CreateDomain operation may take 10 or more seconds to complete.   The client can create up to 100 domains per account.   If the client requires additional domains, go to  http://aws.amazon.com/contact-us/simpledb-limit-request/.

    Args:
        domain_name(str): The name of the domain to create. The name can range between 3 and 255 characters and can contain the following characters: a-z, A-Z, 0-9, '_', '-', and '.'.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.domain.create(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.domain.create domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="create_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def delete(hub, ctx, domain_name: str) -> None:
    r"""
    **Autogenerated function**

     The DeleteDomain operation deletes a domain. Any items (and their attributes) in the domain are deleted as well. The DeleteDomain operation might take 10 or more seconds to complete.

    Args:
        domain_name(str): The name of the domain to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.domain.delete(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.domain.delete domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="delete_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def list_all(
    hub, ctx, max_number_of_domains: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     The ListDomains operation lists all domains associated with the Access Key ID. It returns domain names up to the limit set by MaxNumberOfDomains. A NextToken is returned if there are more than MaxNumberOfDomains domains. Calling ListDomains successive times with the NextToken provided by the operation returns up to MaxNumberOfDomains more domain names with each successive operation call.

    Args:
        max_number_of_domains(int, optional): The maximum number of domain names you want returned. The range is 1 to 100. The default setting is 100. Defaults to None.
        next_token(str, optional): A string informing Amazon SimpleDB where to start the next list of domain names. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.domain.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.domain.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="list_domains",
        op_kwargs={
            "MaxNumberOfDomains": max_number_of_domains,
            "NextToken": next_token,
        },
    )
