"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def batch(hub, ctx, domain_name: str, items: List) -> None:
    r"""
    **Autogenerated function**

     Performs multiple DeleteAttributes operations in a single call, which reduces round trips and latencies. This enables Amazon SimpleDB to optimize requests, which generally yields better throughput.   The following limitations are enforced for this operation:  1 MB request size 25 item limit per BatchDeleteAttributes operation

    Args:
        domain_name(str): The name of the domain in which the attributes are being deleted.
        items(List): A list of items on which to perform the operation.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.delete_attribute.batch(ctx, domain_name=value, items=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.delete_attribute.batch domain_name=value, items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="batch_delete_attributes",
        op_kwargs={"DomainName": domain_name, "Items": items},
    )
