"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(
    hub,
    ctx,
    domain_name: str,
    item_name: str,
    attributes: List = None,
    expected: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

     Deletes one or more attributes associated with an item. If all attributes of the item are deleted, the item is deleted.   DeleteAttributes is an idempotent operation; running it multiple times on the same item or attribute does not result in an error response.   Because Amazon SimpleDB makes multiple copies of item data and uses an eventual consistency update model, performing a GetAttributes or Select operation (read) immediately after a DeleteAttributes or PutAttributes operation (write) might not return updated item data.

    Args:
        domain_name(str): The name of the domain in which to perform the operation.
        item_name(str): The name of the item. Similar to rows on a spreadsheet, items represent individual objects that contain one or more value-attribute pairs.
        attributes(List, optional): A list of Attributes. Similar to columns on a spreadsheet, attributes represent categories of data that can be assigned to items. Defaults to None.
        expected(Dict, optional): The update condition which, if specified, determines whether the specified attributes will be deleted or not. The update condition must be satisfied in order for this request to be processed and the attributes to be deleted. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.attribute.delete_multiple(
                ctx, domain_name=value, item_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.attribute.delete_multiple domain_name=value, item_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="delete_attributes",
        op_kwargs={
            "DomainName": domain_name,
            "ItemName": item_name,
            "Attributes": attributes,
            "Expected": expected,
        },
    )


async def get_all(
    hub,
    ctx,
    domain_name: str,
    item_name: str,
    attribute_names: List = None,
    consistent_read: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns all of the attributes associated with the specified item. Optionally, the attributes returned can be limited to one or more attributes by specifying an attribute name parameter.   If the item does not exist on the replica that was accessed for this operation, an empty set is returned. The system does not return an error as it cannot guarantee the item does not exist on other replicas.

    Args:
        domain_name(str): The name of the domain in which to perform the operation.
        item_name(str): The name of the item.
        attribute_names(List, optional): The names of the attributes. Defaults to None.
        consistent_read(bool, optional): Determines whether or not strong consistency should be enforced when data is read from SimpleDB. If true, any data previously written to SimpleDB will be returned. Otherwise, results will be consistent eventually, and the client may not see data that was written immediately before your read. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.attribute.get_all(ctx, domain_name=value, item_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.attribute.get_all domain_name=value, item_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="get_attributes",
        op_kwargs={
            "DomainName": domain_name,
            "ItemName": item_name,
            "AttributeNames": attribute_names,
            "ConsistentRead": consistent_read,
        },
    )


async def put_multiple(
    hub, ctx, domain_name: str, item_name: str, attributes: List, expected: Dict = None
) -> None:
    r"""
    **Autogenerated function**

     The PutAttributes operation creates or replaces attributes in an item. The client may specify new attributes using a combination of the Attribute.X.Name and Attribute.X.Value parameters. The client specifies the first attribute by the parameters Attribute.0.Name and Attribute.0.Value, the second attribute by the parameters Attribute.1.Name and Attribute.1.Value, and so on.   Attributes are uniquely identified in an item by their name/value combination. For example, a single item can have the attributes { "first_name", "first_value" } and { "first_name", second_value" }. However, it cannot have two attribute instances where both the Attribute.X.Name and Attribute.X.Value are the same.   Optionally, the requestor can supply the Replace parameter for each individual attribute. Setting this value to true causes the new attribute value to replace the existing attribute value(s). For example, if an item has the attributes { 'a', '1' }, { 'b', '2'} and { 'b', '3' } and the requestor calls PutAttributes using the attributes { 'b', '4' } with the Replace parameter set to true, the final attributes of the item are changed to { 'a', '1' } and { 'b', '4' }, which replaces the previous values of the 'b' attribute with the new value.   You cannot specify an empty string as an attribute name.   Because Amazon SimpleDB makes multiple copies of client data and uses an eventual consistency update model, an immediate GetAttributes or Select operation (read) immediately after a PutAttributes or DeleteAttributes operation (write) might not return the updated data.   The following limitations are enforced for this operation:  256 total attribute name-value pairs per item One billion attributes per domain 10 GB of total user data storage per domain

    Args:
        domain_name(str): The name of the domain in which to perform the operation.
        item_name(str): The name of the item.
        attributes(List): The list of attributes.
        expected(Dict, optional): The update condition which, if specified, determines whether the specified attributes will be updated or not. The update condition must be satisfied in order for this request to be processed and the attributes to be updated. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sdb.attribute.put_multiple(
                ctx, domain_name=value, item_name=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sdb.attribute.put_multiple domain_name=value, item_name=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sdb",
        operation="put_attributes",
        op_kwargs={
            "DomainName": domain_name,
            "ItemName": item_name,
            "Attributes": attributes,
            "Expected": expected,
        },
    )
