"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    registry_name: str,
    limit: int = None,
    next_token: str = None,
    schema_name_prefix: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the schemas.

    Args:
        limit(int, optional): . Defaults to None.
        next_token(str, optional): The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts. Defaults to None.
        registry_name(str): The name of the registry.
        schema_name_prefix(str, optional): Specifying this limits the results to only those schema names that start with the specified prefix. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schemas.list(ctx, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schemas.list registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="list_schemas",
        op_kwargs={
            "Limit": limit,
            "NextToken": next_token,
            "RegistryName": registry_name,
            "SchemaNamePrefix": schema_name_prefix,
        },
    )


async def search(
    hub,
    ctx,
    keywords: str,
    registry_name: str,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Search the schemas

    Args:
        keywords(str): Specifying this limits the results to only schemas that include the provided keywords.
        limit(int, optional): . Defaults to None.
        next_token(str, optional): The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts. Defaults to None.
        registry_name(str): The name of the registry.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schemas.search(ctx, keywords=value, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schemas.search keywords=value, registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="search_schemas",
        op_kwargs={
            "Keywords": keywords,
            "Limit": limit,
            "NextToken": next_token,
            "RegistryName": registry_name,
        },
    )
