"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub, ctx, registry_name: str, schema_name: str, schema_version: str
) -> None:
    r"""
    **Autogenerated function**

    Delete the schema version definition

    Args:
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
        schema_version(str): The version number of the schema.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.version.delete(
                ctx, registry_name=value, schema_name=value, schema_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.version.delete registry_name=value, schema_name=value, schema_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="delete_schema_version",
        op_kwargs={
            "RegistryName": registry_name,
            "SchemaName": schema_name,
            "SchemaVersion": schema_version,
        },
    )


async def list_all(
    hub,
    ctx,
    registry_name: str,
    schema_name: str,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of the schema versions and related information.

    Args:
        limit(int, optional): . Defaults to None.
        next_token(str, optional): The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts. Defaults to None.
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.version.list_all(
                ctx, registry_name=value, schema_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.version.list_all registry_name=value, schema_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="list_schema_versions",
        op_kwargs={
            "Limit": limit,
            "NextToken": next_token,
            "RegistryName": registry_name,
            "SchemaName": schema_name,
        },
    )
