"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    content: str,
    registry_name: str,
    schema_name: str,
    type_: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a schema definition. Inactive schemas will be deleted after two years.

    Args:
        content(str): The source of the schema definition.
        description(str, optional): A description of the schema. Defaults to None.
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
        tags(Dict, optional): Tags associated with the schema. Defaults to None.
        type_(str): The type of schema.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.init.create(
                ctx, content=value, registry_name=value, schema_name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.init.create content=value, registry_name=value, schema_name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="create_schema",
        op_kwargs={
            "Content": content,
            "Description": description,
            "RegistryName": registry_name,
            "SchemaName": schema_name,
            "Tags": tags,
            "Type": type_,
        },
    )


async def delete(hub, ctx, registry_name: str, schema_name: str) -> None:
    r"""
    **Autogenerated function**

    Delete a schema definition.

    Args:
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.init.delete(
                ctx, registry_name=value, schema_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.init.delete registry_name=value, schema_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="delete_schema",
        op_kwargs={"RegistryName": registry_name, "SchemaName": schema_name},
    )


async def describe(
    hub, ctx, registry_name: str, schema_name: str, schema_version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the schema definition.

    Args:
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
        schema_version(str, optional): Specifying this limits the results to only this schema version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.init.describe(
                ctx, registry_name=value, schema_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.init.describe registry_name=value, schema_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="describe_schema",
        op_kwargs={
            "RegistryName": registry_name,
            "SchemaName": schema_name,
            "SchemaVersion": schema_version,
        },
    )


async def export(
    hub,
    ctx,
    registry_name: str,
    schema_name: str,
    type_: str,
    schema_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
        schema_version(str, optional): Specifying this limits the results to only this schema version. Defaults to None.
        type_(str): .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.init.export(
                ctx, registry_name=value, schema_name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.init.export registry_name=value, schema_name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="export_schema",
        op_kwargs={
            "RegistryName": registry_name,
            "SchemaName": schema_name,
            "SchemaVersion": schema_version,
            "Type": type_,
        },
    )


async def update(
    hub,
    ctx,
    registry_name: str,
    schema_name: str,
    client_token_id: str = None,
    content: str = None,
    description: str = None,
    type_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the schema definition Inactive schemas will be deleted after two years.

    Args:
        client_token_id(str, optional): The ID of the client token. Defaults to None.
        content(str, optional): The source of the schema definition. Defaults to None.
        description(str, optional): The description of the schema. Defaults to None.
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
        type_(str, optional): The schema type for the events schema. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.schema.init.update(
                ctx, registry_name=value, schema_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.schema.init.update registry_name=value, schema_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="update_schema",
        op_kwargs={
            "ClientTokenId": client_token_id,
            "Content": content,
            "Description": description,
            "RegistryName": registry_name,
            "SchemaName": schema_name,
            "Type": type_,
        },
    )
