"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, registry_name: str = None) -> None:
    r"""
    **Autogenerated function**

    Delete the resource-based policy attached to the specified registry.

    Args:
        registry_name(str, optional): The name of the registry. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.resource.policy.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.resource.policy.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="delete_resource_policy",
        op_kwargs={"RegistryName": registry_name},
    )


async def get(hub, ctx, registry_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the resource-based policy attached to a given registry.

    Args:
        registry_name(str, optional): The name of the registry. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.resource.policy.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.resource.policy.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="get_resource_policy",
        op_kwargs={"RegistryName": registry_name},
    )


async def put(
    hub, ctx, policy: str, registry_name: str = None, revision_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    The name of the policy.

    Args:
        policy(str): The resource-based policy.
        registry_name(str, optional): The name of the registry. Defaults to None.
        revision_id(str, optional): The revision ID of the policy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.resource.policy.put(ctx, policy=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.resource.policy.put policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="put_resource_policy",
        op_kwargs={
            "Policy": policy,
            "RegistryName": registry_name,
            "RevisionId": revision_id,
        },
    )
