"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, registry_name: str, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a registry.

    Args:
        description(str, optional): A description of the registry to be created. Defaults to None.
        registry_name(str): The name of the registry.
        tags(Dict, optional): Tags to associate with the registry. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.registry.create(ctx, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.registry.create registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="create_registry",
        op_kwargs={
            "Description": description,
            "RegistryName": registry_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, registry_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Registry.

    Args:
        registry_name(str): The name of the registry.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.registry.delete(ctx, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.registry.delete registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="delete_registry",
        op_kwargs={"RegistryName": registry_name},
    )


async def describe(hub, ctx, registry_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the registry.

    Args:
        registry_name(str): The name of the registry.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.registry.describe(ctx, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.registry.describe registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="describe_registry",
        op_kwargs={"RegistryName": registry_name},
    )


async def list_all(
    hub,
    ctx,
    limit: int = None,
    next_token: str = None,
    registry_name_prefix: str = None,
    scope: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the registries.

    Args:
        limit(int, optional): . Defaults to None.
        next_token(str, optional): The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts. Defaults to None.
        registry_name_prefix(str, optional): Specifying this limits the results to only those registry names that start with the specified prefix. Defaults to None.
        scope(str, optional): Can be set to Local or AWS to limit responses to your custom registries, or the ones provided by AWS. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.registry.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.registry.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="list_registries",
        op_kwargs={
            "Limit": limit,
            "NextToken": next_token,
            "RegistryNamePrefix": registry_name_prefix,
            "Scope": scope,
        },
    )


async def update(hub, ctx, registry_name: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a registry.

    Args:
        description(str, optional): The description of the registry to update. Defaults to None.
        registry_name(str): The name of the registry.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.registry.update(ctx, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.registry.update registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="update_registry",
        op_kwargs={"Description": description, "RegistryName": registry_name},
    )
