"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, source_arn: str, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a discoverer.

    Args:
        description(str, optional): A description for the discoverer. Defaults to None.
        source_arn(str): The ARN of the event bus.
        tags(Dict, optional): Tags associated with the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.create(ctx, source_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.create source_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="create_discoverer",
        op_kwargs={"Description": description, "SourceArn": source_arn, "Tags": tags},
    )


async def delete(hub, ctx, discoverer_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a discoverer.

    Args:
        discoverer_id(str): The ID of the discoverer.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.delete(ctx, discoverer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.delete discoverer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="delete_discoverer",
        op_kwargs={"DiscovererId": discoverer_id},
    )


async def describe(hub, ctx, discoverer_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the discoverer.

    Args:
        discoverer_id(str): The ID of the discoverer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.describe(ctx, discoverer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.describe discoverer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="describe_discoverer",
        op_kwargs={"DiscovererId": discoverer_id},
    )


async def list_all(
    hub,
    ctx,
    discoverer_id_prefix: str = None,
    limit: int = None,
    next_token: str = None,
    source_arn_prefix: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the discoverers.

    Args:
        discoverer_id_prefix(str, optional): Specifying this limits the results to only those discoverer IDs that start with the specified prefix. Defaults to None.
        limit(int, optional): . Defaults to None.
        next_token(str, optional): The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts. Defaults to None.
        source_arn_prefix(str, optional): Specifying this limits the results to only those ARNs that start with the specified prefix. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="list_discoverers",
        op_kwargs={
            "DiscovererIdPrefix": discoverer_id_prefix,
            "Limit": limit,
            "NextToken": next_token,
            "SourceArnPrefix": source_arn_prefix,
        },
    )


async def start(hub, ctx, discoverer_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts the discoverer

    Args:
        discoverer_id(str): The ID of the discoverer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.start(ctx, discoverer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.start discoverer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="start_discoverer",
        op_kwargs={"DiscovererId": discoverer_id},
    )


async def stop(hub, ctx, discoverer_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the discoverer

    Args:
        discoverer_id(str): The ID of the discoverer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.stop(ctx, discoverer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.stop discoverer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="stop_discoverer",
        op_kwargs={"DiscovererId": discoverer_id},
    )


async def update(hub, ctx, discoverer_id: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the discoverer

    Args:
        description(str, optional): The description of the discoverer to update. Defaults to None.
        discoverer_id(str): The ID of the discoverer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discoverer.update(ctx, discoverer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discoverer.update discoverer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="update_discoverer",
        op_kwargs={"Description": description, "DiscovererId": discoverer_id},
    )
