"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, events: List, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the discovered schema that was generated based on sampled events.

    Args:
        events(List): An array of strings where each string is a JSON event. These are the events that were used to generate the schema. The array includes a single type of event and has a maximum size of 10 events.
        type_(str): The type of event.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.discovered_schema.get(ctx, events=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.discovered_schema.get events=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="get_discovered_schema",
        op_kwargs={"Events": events, "Type": type_},
    )
