"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    language: str,
    registry_name: str,
    schema_name: str,
    schema_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get the code binding source URI.

    Args:
        language(str): The language of the code binding.
        registry_name(str): The name of the registry.
        schema_name(str): The name of the schema.
        schema_version(str, optional): Specifying this limits the results to only this schema version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.schemas.code_binding.source.get(
                ctx, language=value, registry_name=value, schema_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.schemas.code_binding.source.get language=value, registry_name=value, schema_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="schemas",
        operation="get_code_binding_source",
        op_kwargs={
            "Language": language,
            "RegistryName": registry_name,
            "SchemaName": schema_name,
            "SchemaVersion": schema_version,
        },
    )
