"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    savings_plan_id: str,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Savings Plans rates.

    Args:
        savings_plan_id(str): The ID of the Savings Plan.
        filters(List, optional): The filters. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.savingsplan.saving_plan.rate.describe_all(
                ctx, savings_plan_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.savingsplan.saving_plan.rate.describe_all savings_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="savingsplans",
        operation="describe_savings_plan_rates",
        op_kwargs={
            "savingsPlanId": savings_plan_id,
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
