"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    offering_ids: List = None,
    payment_options: List = None,
    product_type: str = None,
    plan_types: List = None,
    durations: List = None,
    currencies: List = None,
    descriptions: List = None,
    service_codes: List = None,
    usage_types: List = None,
    operations: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Savings Plans offerings.

    Args:
        offering_ids(List, optional): The IDs of the offerings. Defaults to None.
        payment_options(List, optional): The payment options. Defaults to None.
        product_type(str, optional): The product type. Defaults to None.
        plan_types(List, optional): The plan type. Defaults to None.
        durations(List, optional): The durations, in seconds. Defaults to None.
        currencies(List, optional): The currencies. Defaults to None.
        descriptions(List, optional): The descriptions. Defaults to None.
        service_codes(List, optional): The services. Defaults to None.
        usage_types(List, optional): The usage details of the line item in the billing report. Defaults to None.
        operations(List, optional): The specific AWS operation for the line item in the billing report. Defaults to None.
        filters(List, optional): The filters. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.savingsplan.saving_plan.offering.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.savingsplan.saving_plan.offering.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="savingsplans",
        operation="describe_savings_plans_offerings",
        op_kwargs={
            "offeringIds": offering_ids,
            "paymentOptions": payment_options,
            "productType": product_type,
            "planTypes": plan_types,
            "durations": durations,
            "currencies": currencies,
            "descriptions": descriptions,
            "serviceCodes": service_codes,
            "usageTypes": usage_types,
            "operations": operations,
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
