"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub,
    ctx,
    feature_group_name: str,
    record_identifier_value_as_string: str,
    event_time: str,
) -> None:
    r"""
    **Autogenerated function**

    Deletes a Record from a FeatureGroup. A new record will show up in the OfflineStore when the DeleteRecord API is called. This record will have a value of True in the is_deleted column.

    Args:
        feature_group_name(str): The name of the feature group to delete the record from. .
        record_identifier_value_as_string(str): The value for the RecordIdentifier that uniquely identifies the record, in string format. .
        event_time(str): Timestamp indicating when the deletion event occurred. EventTime can be used to query data at a certain point in time.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_featurestore_runtime.record.delete(
                ctx,
                feature_group_name=value,
                record_identifier_value_as_string=value,
                event_time=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_featurestore_runtime.record.delete feature_group_name=value, record_identifier_value_as_string=value, event_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-featurestore-runtime",
        operation="delete_record",
        op_kwargs={
            "FeatureGroupName": feature_group_name,
            "RecordIdentifierValueAsString": record_identifier_value_as_string,
            "EventTime": event_time,
        },
    )


async def get(
    hub,
    ctx,
    feature_group_name: str,
    record_identifier_value_as_string: str,
    feature_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use for OnlineStore serving from a FeatureStore. Only the latest records stored in the OnlineStore can be retrieved. If no Record with RecordIdentifierValue is found, then an empty result is returned.

    Args:
        feature_group_name(str): The name of the feature group in which you want to put the records.
        record_identifier_value_as_string(str): The value that corresponds to RecordIdentifier type and uniquely identifies the record in the FeatureGroup. .
        feature_names(List, optional): List of names of Features to be retrieved. If not specified, the latest value for all the Features are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_featurestore_runtime.record.get(
                ctx, feature_group_name=value, record_identifier_value_as_string=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_featurestore_runtime.record.get feature_group_name=value, record_identifier_value_as_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-featurestore-runtime",
        operation="get_record",
        op_kwargs={
            "FeatureGroupName": feature_group_name,
            "RecordIdentifierValueAsString": record_identifier_value_as_string,
            "FeatureNames": feature_names,
        },
    )


async def put(hub, ctx, feature_group_name: str, record: List) -> None:
    r"""
    **Autogenerated function**

    Used for data ingestion into the FeatureStore. The PutRecord API writes to both the OnlineStore and OfflineStore. If the record is the latest record for the recordIdentifier, the record is written to both the OnlineStore and OfflineStore. If the record is a historic record, it is written only to the OfflineStore.

    Args:
        feature_group_name(str): The name of the feature group that you want to insert the record into.
        record(List): List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the feature values, do the following:   Use GetRecord to retrieve the latest record.   Update the record returned from GetRecord.    Use PutRecord to update feature values.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_featurestore_runtime.record.put(
                ctx, feature_group_name=value, record=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_featurestore_runtime.record.put feature_group_name=value, record=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-featurestore-runtime",
        operation="put_record",
        op_kwargs={"FeatureGroupName": feature_group_name, "Record": record},
    )
