"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, identifiers: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a batch of Records from a FeatureGroup.

    Args:
        identifiers(List): A list of FeatureGroup names, with their corresponding RecordIdentifier value, and Feature name that have been requested to be retrieved in batch.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_featurestore_runtime.get_record.batch(
                ctx, identifiers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_featurestore_runtime.get_record.batch identifiers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-featurestore-runtime",
        operation="batch_get_record",
        op_kwargs={"Identifiers": identifiers},
    )
