"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def send(
    hub,
    ctx,
    agent_version: str,
    device_name: str,
    device_fleet_name: str,
    agent_metrics: List = None,
    models: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Use to get the current status of devices registered on SageMaker Edge Manager.

    Args:
        agent_metrics(List, optional): For internal use. Returns a list of SageMaker Edge Manager agent operating metrics. Defaults to None.
        models(List, optional): Returns a list of models deployed on the the device. Defaults to None.
        agent_version(str): Returns the version of the agent.
        device_name(str): The unique name of the device.
        device_fleet_name(str): The name of the fleet that the device belongs to.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_edge.heartbeat.send(
                ctx, agent_version=value, device_name=value, device_fleet_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_edge.heartbeat.send agent_version=value, device_name=value, device_fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-edge",
        operation="send_heartbeat",
        op_kwargs={
            "AgentMetrics": agent_metrics,
            "Models": models,
            "AgentVersion": agent_version,
            "DeviceName": device_name,
            "DeviceFleetName": device_fleet_name,
        },
    )
