"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, device_name: str, device_fleet_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Use to check if a device is registered with SageMaker Edge Manager.

    Args:
        device_name(str): The unique name of the device you want to get the registration status from.
        device_fleet_name(str): The name of the fleet that the device belongs to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_edge.device_registration.get(
                ctx, device_name=value, device_fleet_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_edge.device_registration.get device_name=value, device_fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-edge",
        operation="get_device_registration",
        op_kwargs={"DeviceName": device_name, "DeviceFleetName": device_fleet_name},
    )
