"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, human_loop_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified human loop for a flow definition. If the human loop was deleted, this operation will return a ResourceNotFoundException.

    Args:
        human_loop_name(str): The name of the human loop that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_a2i_runtime_human_loop.delete(
                ctx, human_loop_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_a2i_runtime_human_loop.delete human_loop_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-a2i-runtime",
        operation="delete_human_loop",
        op_kwargs={"HumanLoopName": human_loop_name},
    )


async def describe(hub, ctx, human_loop_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified human loop. If the human loop was deleted, this operation will return a ResourceNotFoundException error.

    Args:
        human_loop_name(str): The name of the human loop that you want information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_a2i_runtime_human_loop.describe(
                ctx, human_loop_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_a2i_runtime_human_loop.describe human_loop_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-a2i-runtime",
        operation="describe_human_loop",
        op_kwargs={"HumanLoopName": human_loop_name},
    )


async def list_all(
    hub,
    ctx,
    flow_definition_arn: str,
    creation_time_after: str = None,
    creation_time_before: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not be included.

    Args:
        creation_time_after(str, optional): (Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For example, 2020-02-24. Defaults to None.
        creation_time_before(str, optional): (Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format. For example, 2020-02-24. Defaults to None.
        flow_definition_arn(str): The Amazon Resource Name (ARN) of a flow definition.
        sort_order(str, optional): Optional. The order for displaying results. Valid values: Ascending and Descending. Defaults to None.
        next_token(str, optional): A token to display the next page of results. Defaults to None.
        max_results(int, optional): The total number of items to return. If the total number of available items is more than the value specified in MaxResults, then a NextToken is returned in the output. You can use this token to display the next page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_a2i_runtime_human_loop.list_all(
                ctx, flow_definition_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_a2i_runtime_human_loop.list_all flow_definition_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-a2i-runtime",
        operation="list_human_loops",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "FlowDefinitionArn": flow_definition_arn,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    human_loop_name: str,
    flow_definition_arn: str,
    human_loop_input: Dict,
    data_attributes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a human loop, provided that at least one activation condition is met.

    Args:
        human_loop_name(str): The name of the human loop.
        flow_definition_arn(str): The Amazon Resource Name (ARN) of the flow definition associated with this human loop.
        human_loop_input(Dict): An object that contains information about the human loop.
        data_attributes(Dict, optional): Attributes of the specified data. Use DataAttributes to specify if your data is free of personally identifiable information and/or free of adult content. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_a2i_runtime_human_loop.start(
                ctx, human_loop_name=value, flow_definition_arn=value, human_loop_input=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_a2i_runtime_human_loop.start human_loop_name=value, flow_definition_arn=value, human_loop_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-a2i-runtime",
        operation="start_human_loop",
        op_kwargs={
            "HumanLoopName": human_loop_name,
            "FlowDefinitionArn": flow_definition_arn,
            "HumanLoopInput": human_loop_input,
            "DataAttributes": data_attributes,
        },
    )


async def stop(hub, ctx, human_loop_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the specified human loop.

    Args:
        human_loop_name(str): The name of the human loop that you want to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker_a2i_runtime_human_loop.stop(
                ctx, human_loop_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker_a2i_runtime_human_loop.stop human_loop_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker-a2i-runtime",
        operation="stop_human_loop",
        op_kwargs={"HumanLoopName": human_loop_name},
    )
