"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    workteam_name: str,
    member_definitions: List,
    description: str,
    workforce_name: str = None,
    notification_configuration: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team. You cannot create more than 25 work teams in an account and region.

    Args:
        workteam_name(str): The name of the work team. Use this name to identify the work team.
        workforce_name(str, optional): The name of the workforce. Defaults to None.
        member_definitions(List): A list of MemberDefinition objects that contains objects that identify the workers that make up the work team.  Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use CognitoMemberDefinition. For workforces created using your own OIDC identity provider (IdP) use OidcMemberDefinition. Do not provide input for both of these parameters in a single request. For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito user groups within the user pool used to create a workforce. All of the CognitoMemberDefinition objects that make up the member definition must have the same ClientId and UserPool values. To add a Amazon Cognito user group to an existing worker pool, see Adding groups to a User Pool. For more information about user pools, see Amazon Cognito User Pools. For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in OidcMemberDefinition by listing those groups in Groups.
        description(str): A description of the work team.
        notification_configuration(Dict, optional): Configures notification of workers regarding available or expiring work items. Defaults to None.
        tags(List, optional): An array of key-value pairs. For more information, see Resource Tag and Using Cost Allocation Tags in the  Amazon Web Services Billing and Cost Management User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workteam.create(
                ctx, workteam_name=value, member_definitions=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workteam.create workteam_name=value, member_definitions=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_workteam",
        op_kwargs={
            "WorkteamName": workteam_name,
            "WorkforceName": workforce_name,
            "MemberDefinitions": member_definitions,
            "Description": description,
            "NotificationConfiguration": notification_configuration,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, workteam_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing work team. This operation can't be undone.

    Args:
        workteam_name(str): The name of the work team to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workteam.delete(ctx, workteam_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workteam.delete workteam_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_workteam",
        op_kwargs={"WorkteamName": workteam_name},
    )


async def describe(hub, ctx, workteam_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).

    Args:
        workteam_name(str): The name of the work team to return a description of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workteam.describe(ctx, workteam_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workteam.describe workteam_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_workteam",
        op_kwargs={"WorkteamName": workteam_name},
    )


async def list_all(
    hub,
    ctx,
    sort_by: str = None,
    sort_order: str = None,
    name_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the NameContains parameter.

    Args:
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.
        name_contains(str, optional): A string in the work team's name. This filter returns only work teams whose name contains the specified string. Defaults to None.
        next_token(str, optional): If the result of the previous ListWorkteams request was truncated, the response includes a NextToken. To retrieve the next set of labeling jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of work teams to return in each page of the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workteam.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workteam.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_workteams",
        op_kwargs={
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NameContains": name_contains,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    workteam_name: str,
    member_definitions: List = None,
    description: str = None,
    notification_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing work team with new member definitions or description.

    Args:
        workteam_name(str): The name of the work team to update.
        member_definitions(List, optional): A list of MemberDefinition objects that contains objects that identify the workers that make up the work team.  Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use CognitoMemberDefinition. For workforces created using your own OIDC identity provider (IdP) use OidcMemberDefinition. You should not provide input for both of these parameters in a single request. For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito user groups within the user pool used to create a workforce. All of the CognitoMemberDefinition objects that make up the member definition must have the same ClientId and UserPool values. To add a Amazon Cognito user group to an existing worker pool, see Adding groups to a User Pool. For more information about user pools, see Amazon Cognito User Pools. For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in OidcMemberDefinition by listing those groups in Groups. Be aware that user groups that are already in the work team must also be listed in Groups when you make this request to remain on the work team. If you do not include these user groups, they will no longer be associated with the work team you update. . Defaults to None.
        description(str, optional): An updated description for the work team. Defaults to None.
        notification_configuration(Dict, optional): Configures SNS topic notifications for available or expiring work items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workteam.update(ctx, workteam_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workteam.update workteam_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_workteam",
        op_kwargs={
            "WorkteamName": workteam_name,
            "MemberDefinitions": member_definitions,
            "Description": description,
            "NotificationConfiguration": notification_configuration,
        },
    )
