"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    workforce_name: str,
    cognito_config: Dict = None,
    oidc_config: Dict = None,
    source_ip_config: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account. If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the API operation to delete the existing workforce and then use CreateWorkforce to create a new workforce. To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in CognitoConfig. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see  Create a Private Workforce (Amazon Cognito). To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in OidcConfig. Your OIDC IdP must support groups because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see  Create a Private Workforce (OIDC IdP).

    Args:
        cognito_config(Dict, optional): Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single  Amazon Cognito user pool. Do not use OidcConfig if you specify values for CognitoConfig. Defaults to None.
        oidc_config(Dict, optional): Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use CognitoConfig if you specify values for OidcConfig. Defaults to None.
        source_ip_config(Dict, optional): A list of IP address ranges (CIDRs). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses. Defaults to None.
        workforce_name(str): The name of the private workforce.
        tags(List, optional): An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workforce.create(ctx, workforce_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workforce.create workforce_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_workforce",
        op_kwargs={
            "CognitoConfig": cognito_config,
            "OidcConfig": oidc_config,
            "SourceIpConfig": source_ip_config,
            "WorkforceName": workforce_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, workforce_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to delete a workforce. If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.  If a private workforce contains one or more work teams, you must use the operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will recieve a ResourceInUse error.

    Args:
        workforce_name(str): The name of the workforce.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workforce.delete(ctx, workforce_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workforce.delete workforce_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_workforce",
        op_kwargs={"WorkforceName": workforce_name},
    )


async def describe(hub, ctx, workforce_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges (CIDRs). Allowable IP address ranges are the IP addresses that workers can use to access tasks.   This operation applies only to private workforces.

    Args:
        workforce_name(str): The name of the private workforce whose access you want to restrict. WorkforceName is automatically set to default when a workforce is created and cannot be modified. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workforce.describe(ctx, workforce_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workforce.describe workforce_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_workforce",
        op_kwargs={"WorkforceName": workforce_name},
    )


async def list_all(
    hub,
    ctx,
    sort_by: str = None,
    sort_order: str = None,
    name_contains: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.

    Args:
        sort_by(str, optional): Sort workforces using the workforce name or creation date. Defaults to None.
        sort_order(str, optional): Sort workforces in ascending or descending order. Defaults to None.
        name_contains(str, optional): A filter you can use to search for workforces using part of the workforce name. Defaults to None.
        next_token(str, optional): A token to resume pagination. Defaults to None.
        max_results(int, optional): The maximum number of workforces returned in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workforce.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workforce.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_workforces",
        op_kwargs={
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NameContains": name_contains,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    workforce_name: str,
    source_ip_config: Dict = None,
    oidc_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.  Use SourceIpConfig to restrict worker access to tasks to a specific range of IP addresses. You specify allowed IP addresses by creating a list of up to ten CIDRs. By default, a workforce isn't restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied and get a Not Found error message on the worker portal. Use OidcConfig to update the configuration of a workforce created using your own OIDC IdP.   You can only update your OIDC IdP configuration when there are no work teams associated with your workforce. You can delete work teams using the operation.  After restricting access to a range of IP addresses or updating your OIDC IdP configuration with this operation, you can view details about your update workforce using the operation.  This operation only applies to private workforces.

    Args:
        workforce_name(str): The name of the private workforce that you want to update. You can find your workforce name by using the operation.
        source_ip_config(Dict, optional): A list of one to ten worker IP address ranges (CIDRs) that can be used to access tasks assigned to this workforce. Maximum: Ten CIDR values. Defaults to None.
        oidc_config(Dict, optional): Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your own IdP. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.workforce.update(ctx, workforce_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.workforce.update workforce_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_workforce",
        op_kwargs={
            "WorkforceName": workforce_name,
            "SourceIpConfig": source_ip_config,
            "OidcConfig": oidc_config,
        },
    )
