"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_id: str,
    user_profile_name: str,
    single_sign_on_user_identifier: str = None,
    single_sign_on_user_value: str = None,
    tags: List = None,
    user_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.

    Args:
        domain_id(str): The ID of the associated Domain.
        user_profile_name(str): A name for the UserProfile. This value is not case sensitive.
        single_sign_on_user_identifier(str, optional): A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified. . Defaults to None.
        single_sign_on_user_value(str, optional): The username of the associated Amazon Web Services Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified. . Defaults to None.
        tags(List, optional): Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags that you specify for the User Profile are also added to all Apps that the User Profile launches. Defaults to None.
        user_settings(Dict, optional): A collection of settings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.user_profile.create(
                ctx, domain_id=value, user_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.user_profile.create domain_id=value, user_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_user_profile",
        op_kwargs={
            "DomainId": domain_id,
            "UserProfileName": user_profile_name,
            "SingleSignOnUserIdentifier": single_sign_on_user_identifier,
            "SingleSignOnUserValue": single_sign_on_user_value,
            "Tags": tags,
            "UserSettings": user_settings,
        },
    )


async def delete(hub, ctx, domain_id: str, user_profile_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The user profile name.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.user_profile.delete(
                ctx, domain_id=value, user_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.user_profile.delete domain_id=value, user_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_user_profile",
        op_kwargs={"DomainId": domain_id, "UserProfileName": user_profile_name},
    )


async def describe(hub, ctx, domain_id: str, user_profile_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a user profile. For more information, see CreateUserProfile.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The user profile name. This value is not case sensitive.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.user_profile.describe(
                ctx, domain_id=value, user_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.user_profile.describe domain_id=value, user_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_user_profile",
        op_kwargs={"DomainId": domain_id, "UserProfileName": user_profile_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    sort_order: str = None,
    sort_by: str = None,
    domain_id_equals: str = None,
    user_profile_name_contains: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists user profiles.

    Args:
        next_token(str, optional): If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results. Defaults to None.
        max_results(int, optional): Returns a list up to a specified limit. Defaults to None.
        sort_order(str, optional): The sort order for the results. The default is Ascending. Defaults to None.
        sort_by(str, optional): The parameter by which to sort the results. The default is CreationTime. Defaults to None.
        domain_id_equals(str, optional): A parameter by which to filter the results. Defaults to None.
        user_profile_name_contains(str, optional): A parameter by which to filter the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.user_profile.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.user_profile.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_user_profiles",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortOrder": sort_order,
            "SortBy": sort_by,
            "DomainIdEquals": domain_id_equals,
            "UserProfileNameContains": user_profile_name_contains,
        },
    )


async def update(
    hub, ctx, domain_id: str, user_profile_name: str, user_settings: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a user profile.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The user profile name.
        user_settings(Dict, optional): A collection of settings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.user_profile.update(
                ctx, domain_id=value, user_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.user_profile.update domain_id=value, user_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_user_profile",
        op_kwargs={
            "DomainId": domain_id,
            "UserProfileName": user_profile_name,
            "UserSettings": user_settings,
        },
    )
