"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def render(
    hub,
    ctx,
    task: Dict,
    role_arn: str,
    ui_template: Dict = None,
    human_task_ui_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Renders the UI template so that you can preview the worker's experience.

    Args:
        ui_template(Dict, optional): A Template object containing the worker UI template to render. Defaults to None.
        task(Dict): A RenderableTask object containing a representative task to render.
        role_arn(str): The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
        human_task_ui_arn(str, optional): The HumanTaskUiArn of the worker UI that you want to render. Do not provide a HumanTaskUiArn if you use the UiTemplate parameter. See a list of available Human Ui Amazon Resource Names (ARNs) in UiConfig. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.ui_template.render(ctx, task=value, role_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.ui_template.render task=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="render_ui_template",
        op_kwargs={
            "UiTemplate": ui_template,
            "Task": task,
            "RoleArn": role_arn,
            "HumanTaskUiArn": human_task_ui_arn,
        },
    )
