"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    trial_name: str,
    experiment_name: str,
    display_name: str = None,
    metadata_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an SageMaker trial. A trial is a set of steps called trial components that produce a machine learning model. A trial is part of a single SageMaker experiment. When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK. You can add tags to a trial and then use the Search API to search for the tags. To get a list of all your trials, call the ListTrials API. To view a trial's properties, call the DescribeTrial API. To create a trial component, call the CreateTrialComponent API.

    Args:
        trial_name(str): The name of the trial. The name must be unique in your Amazon Web Services account and is not case-sensitive.
        display_name(str, optional): The name of the trial as displayed. The name doesn't need to be unique. If DisplayName isn't specified, TrialName is displayed. Defaults to None.
        experiment_name(str): The name of the experiment to associate the trial with.
        metadata_properties(Dict, optional): Metadata properties of the tracking entity, trial, or trial component. Defaults to None.
        tags(List, optional): A list of tags to associate with the trial. You can use Search API to search on the tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.init.create(
                ctx, trial_name=value, experiment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.init.create trial_name=value, experiment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_trial",
        op_kwargs={
            "TrialName": trial_name,
            "DisplayName": display_name,
            "ExperimentName": experiment_name,
            "MetadataProperties": metadata_properties,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, trial_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the DescribeTrialComponent API to get the list of trial components.

    Args:
        trial_name(str): The name of the trial to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.init.delete(ctx, trial_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.init.delete trial_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_trial",
        op_kwargs={"TrialName": trial_name},
    )


async def describe(hub, ctx, trial_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of a trial's properties.

    Args:
        trial_name(str): The name of the trial to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.init.describe(ctx, trial_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.init.describe trial_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_trial",
        op_kwargs={"TrialName": trial_name},
    )


async def list_all(
    hub,
    ctx,
    experiment_name: str = None,
    trial_component_name: str = None,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.

    Args:
        experiment_name(str, optional): A filter that returns only trials that are part of the specified experiment. Defaults to None.
        trial_component_name(str, optional): A filter that returns only trials that are associated with the specified trial component. Defaults to None.
        created_after(str, optional): A filter that returns only trials created after the specified time. Defaults to None.
        created_before(str, optional): A filter that returns only trials created before the specified time. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order. The default value is Descending. Defaults to None.
        max_results(int, optional): The maximum number of trials to return in the response. The default value is 10. Defaults to None.
        next_token(str, optional): If the previous call to ListTrials didn't return the full set of trials, the call returns a token for getting the next set of trials. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_trials",
        op_kwargs={
            "ExperimentName": experiment_name,
            "TrialComponentName": trial_component_name,
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, trial_name: str, display_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the display name of a trial.

    Args:
        trial_name(str): The name of the trial to update.
        display_name(str, optional): The name of the trial as displayed. The name doesn't need to be unique. If DisplayName isn't specified, TrialName is displayed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.init.update(ctx, trial_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.init.update trial_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_trial",
        op_kwargs={"TrialName": trial_name, "DisplayName": display_name},
    )
