"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, trial_component_name: str, trial_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.

    Args:
        trial_component_name(str): The name of the component to associated with the trial.
        trial_name(str): The name of the trial to associate with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.associate(
                ctx, trial_component_name=value, trial_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.associate trial_component_name=value, trial_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="associate_trial_component",
        op_kwargs={"TrialComponentName": trial_component_name, "TrialName": trial_name},
    )


async def create(
    hub,
    ctx,
    trial_component_name: str,
    display_name: str = None,
    status: Dict = None,
    start_time: str = None,
    end_time: str = None,
    parameters: Dict = None,
    input_artifacts: Dict = None,
    output_artifacts: Dict = None,
    metadata_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a trial component, which is a stage of a machine learning trial. A trial is composed of one or more trial components. A trial component can be used in multiple trials. Trial components include pre-processing jobs, training jobs, and batch transform jobs. When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK. You can add tags to a trial component and then use the Search API to search for the tags.

    Args:
        trial_component_name(str): The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.
        display_name(str, optional): The name of the component as displayed. The name doesn't need to be unique. If DisplayName isn't specified, TrialComponentName is displayed. Defaults to None.
        status(Dict, optional): The status of the component. States include:   InProgress   Completed   Failed  . Defaults to None.
        start_time(str, optional): When the component started. Defaults to None.
        end_time(str, optional): When the component ended. Defaults to None.
        parameters(Dict, optional): The hyperparameters for the component. Defaults to None.
        input_artifacts(Dict, optional): The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types. Defaults to None.
        output_artifacts(Dict, optional): The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images. Defaults to None.
        metadata_properties(Dict, optional): Metadata properties of the tracking entity, trial, or trial component. Defaults to None.
        tags(List, optional): A list of tags to associate with the component. You can use Search API to search on the tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.create(
                ctx, trial_component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.create trial_component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_trial_component",
        op_kwargs={
            "TrialComponentName": trial_component_name,
            "DisplayName": display_name,
            "Status": status,
            "StartTime": start_time,
            "EndTime": end_time,
            "Parameters": parameters,
            "InputArtifacts": input_artifacts,
            "OutputArtifacts": output_artifacts,
            "MetadataProperties": metadata_properties,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, trial_component_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.

    Args:
        trial_component_name(str): The name of the component to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.delete(
                ctx, trial_component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.delete trial_component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_trial_component",
        op_kwargs={"TrialComponentName": trial_component_name},
    )


async def describe(hub, ctx, trial_component_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of a trials component's properties.

    Args:
        trial_component_name(str): The name of the trial component to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.describe(
                ctx, trial_component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.describe trial_component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_trial_component",
        op_kwargs={"TrialComponentName": trial_component_name},
    )


async def disassociate(hub, ctx, trial_component_name: str, trial_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the AssociateTrialComponent API. To get a list of the trials a component is associated with, use the Search API. Specify ExperimentTrialComponent for the Resource parameter. The list appears in the response under Results.TrialComponent.Parents.

    Args:
        trial_component_name(str): The name of the component to disassociate from the trial.
        trial_name(str): The name of the trial to disassociate from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.disassociate(
                ctx, trial_component_name=value, trial_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.disassociate trial_component_name=value, trial_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="disassociate_trial_component",
        op_kwargs={"TrialComponentName": trial_component_name, "TrialName": trial_name},
    )


async def list_all(
    hub,
    ctx,
    experiment_name: str = None,
    trial_name: str = None,
    source_arn: str = None,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:    ExperimentName     SourceArn     TrialName

    Args:
        experiment_name(str, optional): A filter that returns only components that are part of the specified experiment. If you specify ExperimentName, you can't filter by SourceArn or TrialName. Defaults to None.
        trial_name(str, optional): A filter that returns only components that are part of the specified trial. If you specify TrialName, you can't filter by ExperimentName or SourceArn. Defaults to None.
        source_arn(str, optional): A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you specify SourceArn, you can't filter by ExperimentName or TrialName. Defaults to None.
        created_after(str, optional): A filter that returns only components created after the specified time. Defaults to None.
        created_before(str, optional): A filter that returns only components created before the specified time. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order. The default value is Descending. Defaults to None.
        max_results(int, optional): The maximum number of components to return in the response. The default value is 10. Defaults to None.
        next_token(str, optional): If the previous call to ListTrialComponents didn't return the full set of components, the call returns a token for getting the next set of components. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_trial_components",
        op_kwargs={
            "ExperimentName": experiment_name,
            "TrialName": trial_name,
            "SourceArn": source_arn,
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    trial_component_name: str,
    display_name: str = None,
    status: Dict = None,
    start_time: str = None,
    end_time: str = None,
    parameters: Dict = None,
    parameters_to_remove: List = None,
    input_artifacts: Dict = None,
    input_artifacts_to_remove: List = None,
    output_artifacts: Dict = None,
    output_artifacts_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates one or more properties of a trial component.

    Args:
        trial_component_name(str): The name of the component to update.
        display_name(str, optional): The name of the component as displayed. The name doesn't need to be unique. If DisplayName isn't specified, TrialComponentName is displayed. Defaults to None.
        status(Dict, optional): The new status of the component. Defaults to None.
        start_time(str, optional): When the component started. Defaults to None.
        end_time(str, optional): When the component ended. Defaults to None.
        parameters(Dict, optional): Replaces all of the component's hyperparameters with the specified hyperparameters. Defaults to None.
        parameters_to_remove(List, optional): The hyperparameters to remove from the component. Defaults to None.
        input_artifacts(Dict, optional): Replaces all of the component's input artifacts with the specified artifacts. Defaults to None.
        input_artifacts_to_remove(List, optional): The input artifacts to remove from the component. Defaults to None.
        output_artifacts(Dict, optional): Replaces all of the component's output artifacts with the specified artifacts. Defaults to None.
        output_artifacts_to_remove(List, optional): The output artifacts to remove from the component. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.trial.component.update(
                ctx, trial_component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.trial.component.update trial_component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_trial_component",
        op_kwargs={
            "TrialComponentName": trial_component_name,
            "DisplayName": display_name,
            "Status": status,
            "StartTime": start_time,
            "EndTime": end_time,
            "Parameters": parameters,
            "ParametersToRemove": parameters_to_remove,
            "InputArtifacts": input_artifacts,
            "InputArtifactsToRemove": input_artifacts_to_remove,
            "OutputArtifacts": output_artifacts,
            "OutputArtifactsToRemove": output_artifacts_to_remove,
        },
    )
