"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    transform_job_name: str,
    model_name: str,
    transform_input: Dict,
    transform_output: Dict,
    transform_resources: Dict,
    max_concurrent_transforms: int = None,
    model_client_config: Dict = None,
    max_payload_in_mb: int = None,
    batch_strategy: str = None,
    environment: Dict = None,
    data_processing: Dict = None,
    tags: List = None,
    experiment_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify. To perform batch transformations, you create a transform job and use the data that you have readily available. In the request body, you provide the following:    TransformJobName - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.    ModelName - Identifies the model to use. ModelName must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see CreateModel.    TransformInput - Describes the dataset to be transformed and the Amazon S3 location where it is stored.    TransformOutput - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.    TransformResources - Identifies the ML compute instances for the transform job.   For more information about how batch transformation works, see Batch Transform.

    Args:
        transform_job_name(str): The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. .
        model_name(str): The name of the model that you want to use for the transform job. ModelName must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.
        max_concurrent_transforms(int, optional): The maximum number of parallel requests that can be sent to each instance in a transform job. If MaxConcurrentTransforms is set to 0 or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is 1. For more information on execution-parameters, see How Containers Serve Requests. For built-in algorithms, you don't need to set a value for MaxConcurrentTransforms. Defaults to None.
        model_client_config(Dict, optional): Configures the timeout and maximum number of retries for processing a transform job invocation. Defaults to None.
        max_payload_in_mb(int, optional): The maximum allowed size of the payload, in MB. A payload is the data portion of a record (without metadata). The value in MaxPayloadInMB must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is 6 MB.  For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to 0. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding. Defaults to None.
        batch_strategy(str, optional): Specifies the number of records to include in a mini-batch for an HTTP inference request. A record  is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.  To enable the batch strategy, you must set the SplitType property to Line, RecordIO, or TFRecord. To use only one record when making an HTTP invocation request to a container, set BatchStrategy to SingleRecord and SplitType to Line. To fit as many records in a mini-batch as can fit within the MaxPayloadInMB limit, set BatchStrategy to MultiRecord and SplitType to Line. Defaults to None.
        environment(Dict, optional): The environment variables to set in the Docker container. We support up to 16 key and values entries in the map. Defaults to None.
        transform_input(Dict): Describes the input source and the way the transform job consumes it.
        transform_output(Dict): Describes the results of the transform job.
        transform_resources(Dict): Describes the resources, including ML instance types and ML instance count, to use for the transform job.
        data_processing(Dict, optional): The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see Associate Prediction Results with their Corresponding Input Records. Defaults to None.
        tags(List, optional): (Optional) An array of key-value pairs. For more information, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management User Guide. Defaults to None.
        experiment_config(Dict, optional): Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:    CreateProcessingJob     CreateTrainingJob     CreateTransformJob   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.transform_job.create(
                ctx,
                transform_job_name=value,
                model_name=value,
                transform_input=value,
                transform_output=value,
                transform_resources=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.transform_job.create transform_job_name=value, model_name=value, transform_input=value, transform_output=value, transform_resources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_transform_job",
        op_kwargs={
            "TransformJobName": transform_job_name,
            "ModelName": model_name,
            "MaxConcurrentTransforms": max_concurrent_transforms,
            "ModelClientConfig": model_client_config,
            "MaxPayloadInMB": max_payload_in_mb,
            "BatchStrategy": batch_strategy,
            "Environment": environment,
            "TransformInput": transform_input,
            "TransformOutput": transform_output,
            "TransformResources": transform_resources,
            "DataProcessing": data_processing,
            "Tags": tags,
            "ExperimentConfig": experiment_config,
        },
    )


async def describe(hub, ctx, transform_job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a transform job.

    Args:
        transform_job_name(str): The name of the transform job that you want to view details of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.transform_job.describe(ctx, transform_job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.transform_job.describe transform_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_transform_job",
        op_kwargs={"TransformJobName": transform_job_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    name_contains: str = None,
    status_equals: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists transform jobs.

    Args:
        creation_time_after(str, optional): A filter that returns only transform jobs created after the specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns only transform jobs created before the specified time. Defaults to None.
        last_modified_time_after(str, optional): A filter that returns only transform jobs modified after the specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only transform jobs modified before the specified time. Defaults to None.
        name_contains(str, optional): A string in the transform job name. This filter returns only transform jobs whose name contains the specified string. Defaults to None.
        status_equals(str, optional): A filter that retrieves only transform jobs with a specific status. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Descending. Defaults to None.
        next_token(str, optional): If the result of the previous ListTransformJobs request was truncated, the response includes a NextToken. To retrieve the next set of transform jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of transform jobs to return in the response. The default value is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.transform_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.transform_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_transform_jobs",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "NameContains": name_contains,
            "StatusEquals": status_equals,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def stop(hub, ctx, transform_job_name: str) -> None:
    r"""
    **Autogenerated function**

    Stops a transform job. When Amazon SageMaker receives a StopTransformJob request, the status of the job changes to Stopping. After Amazon SageMaker stops the job, the status is set to Stopped. When you stop a transform job before it is completed, Amazon SageMaker doesn't store the job's output in Amazon S3.

    Args:
        transform_job_name(str): The name of the transform job to stop.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.transform_job.stop(ctx, transform_job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.transform_job.stop transform_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_transform_job",
        op_kwargs={"TransformJobName": transform_job_name},
    )
