"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    hyper_parameter_tuning_job_name: str,
    next_token: str = None,
    max_results: int = None,
    status_equals: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of TrainingJobSummary objects that describe the training jobs that a hyperparameter tuning job launched.

    Args:
        hyper_parameter_tuning_job_name(str): The name of the tuning job whose training jobs you want to list.
        next_token(str, optional): If the result of the previous ListTrainingJobsForHyperParameterTuningJob request was truncated, the response includes a NextToken. To retrieve the next set of training jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of training jobs to return. The default value is 10. Defaults to None.
        status_equals(str, optional): A filter that returns only training jobs with the specified status. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is Name. If the value of this field is FinalObjectiveMetricValue, any training jobs that did not return an objective metric are not listed. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.training_jobs_for_hyper_parameter_tuning_job.list(
                ctx, hyper_parameter_tuning_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.training_jobs_for_hyper_parameter_tuning_job.list hyper_parameter_tuning_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_training_jobs_for_hyper_parameter_tuning_job",
        op_kwargs={
            "HyperParameterTuningJobName": hyper_parameter_tuning_job_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "StatusEquals": status_equals,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )
