"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, workteam_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.

    Args:
        workteam_arn(str): The Amazon Resource Name (ARN) of the subscribed work team to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.subscribed_workteam.describe(ctx, workteam_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.subscribed_workteam.describe workteam_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_subscribed_workteam",
        op_kwargs={"WorkteamArn": workteam_arn},
    )


async def list_all(
    hub, ctx, name_contains: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the NameContains parameter.

    Args:
        name_contains(str, optional): A string in the work team name. This filter returns only work teams whose name contains the specified string. Defaults to None.
        next_token(str, optional): If the result of the previous ListSubscribedWorkteams request was truncated, the response includes a NextToken. To retrieve the next set of labeling jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of work teams to return in each page of the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.subscribed_workteam.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.subscribed_workteam.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_subscribed_workteams",
        op_kwargs={
            "NameContains": name_contains,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
