"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, resource: str, suggestion_query: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in Search queries. Provides suggestions for HyperParameters, Tags, and Metrics.

    Args:
        resource(str): The name of the Amazon SageMaker resource to search for.
        suggestion_query(Dict, optional): Limits the property names that are included in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.search_suggestion.get_all(ctx, resource=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.search_suggestion.get_all resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="get_search_suggestions",
        op_kwargs={"Resource": resource, "SuggestionQuery": suggestion_query},
    )
