"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.sagemaker_servicecatalog_portfolio.status.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.sagemaker_servicecatalog_portfolio.status.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="get_sagemaker_servicecatalog_portfolio_status",
        op_kwargs={},
    )
