"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.sagemaker_servicecatalog_portfolio.init.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.sagemaker_servicecatalog_portfolio.init.disable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="disable_sagemaker_servicecatalog_portfolio",
        op_kwargs={},
    )


async def enable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.sagemaker_servicecatalog_portfolio.init.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.sagemaker_servicecatalog_portfolio.init.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="enable_sagemaker_servicecatalog_portfolio",
        op_kwargs={},
    )
