"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    project_name: str,
    service_catalog_provisioning_details: Dict,
    project_description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.

    Args:
        project_name(str): The name of the project.
        project_description(str, optional): A description for the project. Defaults to None.
        service_catalog_provisioning_details(Dict): The product ID and provisioning artifact ID to provision a service catalog. For information, see What is Amazon Web Services Service Catalog.
        tags(List, optional): An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource costs. For more information, see Tagging Amazon Web Services resources in the Amazon Web Services General Reference Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.project.create(
                ctx, project_name=value, service_catalog_provisioning_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.project.create project_name=value, service_catalog_provisioning_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_project",
        op_kwargs={
            "ProjectName": project_name,
            "ProjectDescription": project_description,
            "ServiceCatalogProvisioningDetails": service_catalog_provisioning_details,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, project_name: str) -> None:
    r"""
    **Autogenerated function**

    Delete the specified project.

    Args:
        project_name(str): The name of the project to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.project.delete(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.project.delete project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_project",
        op_kwargs={"ProjectName": project_name},
    )


async def describe(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the details of a project.

    Args:
        project_name(str): The name of the project to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.project.describe(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.project.describe project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_project",
        op_kwargs={"ProjectName": project_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    max_results: int = None,
    name_contains: str = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the projects in an Amazon Web Services account.

    Args:
        creation_time_after(str, optional): A filter that returns the projects that were created after a specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns the projects that were created before a specified time. Defaults to None.
        max_results(int, optional): The maximum number of projects to return in the response. Defaults to None.
        name_contains(str, optional): A filter that returns the projects whose name contains a specified string. Defaults to None.
        next_token(str, optional): If the result of the previous ListProjects request was truncated, the response includes a NextToken. To retrieve the next set of projects, use the token in the next request. Defaults to None.
        sort_by(str, optional): The field by which to sort results. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_projects",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "NextToken": next_token,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )
