"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    processing_job_name: str,
    processing_resources: Dict,
    app_specification: Dict,
    role_arn: str,
    processing_inputs: List = None,
    processing_output_config: Dict = None,
    stopping_condition: Dict = None,
    environment: Dict = None,
    network_config: Dict = None,
    tags: List = None,
    experiment_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a processing job.

    Args:
        processing_inputs(List, optional): An array of inputs configuring the data to download into the processing container. Defaults to None.
        processing_output_config(Dict, optional): Output configuration for the processing job. Defaults to None.
        processing_job_name(str):  The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
        processing_resources(Dict): Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.
        stopping_condition(Dict, optional): The time limit for how long the processing job is allowed to run. Defaults to None.
        app_specification(Dict): Configures the processing job to run a specified Docker container image.
        environment(Dict, optional): The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported. Defaults to None.
        network_config(Dict, optional): Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        tags(List, optional): (Optional) An array of key-value pairs. For more information, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management User Guide. Defaults to None.
        experiment_config(Dict, optional): Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:    CreateProcessingJob     CreateTrainingJob     CreateTransformJob   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.processing_job.create(
                ctx,
                processing_job_name=value,
                processing_resources=value,
                app_specification=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.processing_job.create processing_job_name=value, processing_resources=value, app_specification=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_processing_job",
        op_kwargs={
            "ProcessingInputs": processing_inputs,
            "ProcessingOutputConfig": processing_output_config,
            "ProcessingJobName": processing_job_name,
            "ProcessingResources": processing_resources,
            "StoppingCondition": stopping_condition,
            "AppSpecification": app_specification,
            "Environment": environment,
            "NetworkConfig": network_config,
            "RoleArn": role_arn,
            "Tags": tags,
            "ExperimentConfig": experiment_config,
        },
    )


async def describe(hub, ctx, processing_job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of a processing job.

    Args:
        processing_job_name(str): The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.processing_job.describe(
                ctx, processing_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.processing_job.describe processing_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_processing_job",
        op_kwargs={"ProcessingJobName": processing_job_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    name_contains: str = None,
    status_equals: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists processing jobs that satisfy various filters.

    Args:
        creation_time_after(str, optional): A filter that returns only processing jobs created after the specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns only processing jobs created after the specified time. Defaults to None.
        last_modified_time_after(str, optional): A filter that returns only processing jobs modified after the specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only processing jobs modified before the specified time. Defaults to None.
        name_contains(str, optional): A string in the processing job name. This filter returns only processing jobs whose name contains the specified string. Defaults to None.
        status_equals(str, optional): A filter that retrieves only processing jobs with a specific status. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.
        next_token(str, optional): If the result of the previous ListProcessingJobs request was truncated, the response includes a NextToken. To retrieve the next set of processing jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of processing jobs to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.processing_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.processing_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_processing_jobs",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "NameContains": name_contains,
            "StatusEquals": status_equals,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def stop(hub, ctx, processing_job_name: str) -> None:
    r"""
    **Autogenerated function**

    Stops a processing job.

    Args:
        processing_job_name(str): The name of the processing job to stop.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.processing_job.stop(ctx, processing_job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.processing_job.stop processing_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_processing_job",
        op_kwargs={"ProcessingJobName": processing_job_name},
    )
